/* IBM_PROLOG_BEGIN_TAG                                                   */
/* This is an automatically generated prolog.                             */
/*                                                                        */
/*                                                                        */
/*                                                                        */
/* Licensed Materials - Property of IBM                                   */
/*                                                                        */
/* (C) COPYRIGHT International Business Machines Corp. 1998,2001          */
/* All Rights Reserved                                                    */
/*                                                                        */
/* US Government Users Restricted Rights - Use, duplication or            */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.      */
/*                                                                        */
/* IBM_PROLOG_END_TAG                                                     */

static char *sccsid = "@(#)44   1.3   src/rsct/pgs/samples/Sample_Frame.C, gssamples, rsct_rori, roris01a 5/14/01 09:43:22";

#if !defined(_HAGSD_COPYRIGHT_H)
#define _HAGSD_COPYRIGHT_H
static char copyright[] = "Licensed Materials - Property of IBM\n\
(C) COPYRIGHT International Business Machines Corp. 1998,2001.\n\
All Rights Reserved.\n\
US Government Users Restricted Rights - Use, duplication or \n\
disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n";
#endif

/*********************************************************************/
/*
 * Name:  Sample_Frame.C
 *
 * Define a frame.  Contains a slot for each possible node that may
 * be in the frame, the node in turn contains the providers.
 *
 * See Sample_Subscribe.C for more info.
 */
 /*********************************************************************/

#include "Sample_Frame.h"           // Standard includes.
#include "Sample_Node.h"            // Define the Node objects.

Frame::Frame(int _frame,
             int _slot,
             short _instance,
             unsigned int *_IPaddr,
             ha_gs_adapter_death_t *_death)
{
    myFrameNumber = _frame;

    for (int i = 1; i <= NODES_PER_FRAME; i++) {
        nodeTable[i] = new Node(_slot);
    }

    count = highestProvCount = nodeTable[_slot]->Add(_instance,
                                                     _IPaddr,
                                                     _death);

    return;
}

Frame::~Frame(void)
{
    for (int i = 1; i <= NODES_PER_FRAME; i++) {
        delete nodeTable[i];
    }

    return;
}

/*********************************************************************/
/*
 * Add a provider into the correct node.  Return number of providers
 * in frame.
 */
/*********************************************************************/
int     Frame::Add(short _instance,
                   short _slot,
                   unsigned int *_IPaddr,
                   ha_gs_adapter_death_t *_death)
{
    int _pCount;

    if (highestProvCount <
        (_pCount = nodeTable[_slot]->Add(_instance,
                                         _IPaddr,
                                         _death))) highestProvCount = _pCount;

    return(++count);
}

/*********************************************************************/
/*
 * Print out the frame.  Want to print out frame number once, then
 * allow each node to print out its providers.
 */
/*********************************************************************/

void    Frame::Print(void)
{
    if (0 == count) return;             // Nothing to do.

    char  _buf[10];
    int   _spaces = 4;

    // Now, go through list of nodes, telling each node to print out its
    // providers.  Do this for each known provider index (i.e., if no node
    // has more than one provider, do it once; if a node has two, do it
    // twice, etc.)

    for (int _index = 0; _index < highestProvCount; _index++) {
        memset(_buf, '\0', 10);
        if (0 == _index) {
            if (0 == myFrameNumber) {
                strcpy(_buf, "CWS:  ");
            } else {
                sprintf(_buf, "%3d:  ", myFrameNumber);
            }
        } else {
            strcpy(_buf, "      ");
        }
        cout << _buf;                   // Print frame number

        for (int _node = 1; _node <= NODES_PER_FRAME; _node++) {
            nodeTable[_node]->PrintFancy(_index, _spaces);
        }
        cout << endl;
    }

    return;
}
